
$(document).ready(function(){
	$("body").width(0.98 * window.innerWidth);
	$("#noresponde").hide();
	$("#rotulo").append(
		rotulo.codigo + " rev " + rotulo.revision + " - Vigencia " +
		rotulo.vigencia + " - Version " + rotulo.revision + "." + rotulo.version
	);
	//FUNCIONALIDAD EN BOTONES DE CONFIGURACION, REGISTRO, EVENTO Y MONITOREO
	
	//instalo funcion para manejar error de pedidos ajax
	$.ajaxSetup({
		error: function (e){
			if(!( $("#BotRegistros").hasClass("active") ) ){
				$("#article").hide();
			}
			$("#noresponde").show();
		}
	});
	
	//instalo onlick del menu ppal
	$("nav > ul > li.button").click(function(e){
		$(".button.active").removeClass("active");
		$("#article").css("display", "none");			
		$("#article").html("");
		$("#menusecundario").remove();
		$("#noresponde").hide();
		
		switch(this.id){
		case "BotRegistros":
			onclick_Registros();
			break;
		case "BotEventos":
			onclick_Anuncios();
			break;
		case "BotMonitoreo":
			$("#article").html("");
			$("#nav").append(	"<ul id='menusecundario'><li class=button2 id='Captores'>Captores</li>"+
														"<li class=button2 id='Corrientes'>Corrientes</li>"+
														"<li class=button2 id='Entradas'>Entradas</li>"+
														"<li class=button2 id='Modulos'>Módulos</li>"+
														"<li class=button2 id='Sistema'>Sistema</li></ul>");
			$("#article").append("<h3 class=texto>Selecione un tipo de Monitoreo</h3>");
			$("#article").show();
			$(".button.active").removeClass("active");
			$(this).addClass("active");			
			break;
		default:
			break;
		}
	});
	
	//instalo funciones onclick del submenu monitoreo
	$("#nav").on('click', '#Captores', onclick_Captores);
	
	$("#nav").on('click', '#Corrientes', onclick_Corrientes);
	
	$("#nav").on('click', '#Entradas', onclick_Entradas);
	
	$("#nav").on('click', '#Modulos', onclick_Modulos);
	
	$("#nav").on('click', '#Sistema', onclick_Sistema);


	//instalo funciones onclick del submenu filtro de registros
	$("#nav").on('click', '#General', function(e){
		$(".button2.active").removeClass("active");  
		$("#General").addClass("active");
		imprime_registros();	
	});
	
	$("#nav").on('click', '#Monitoreo', function(e){
		$(".button2.active").removeClass("active");  
		$("#Monitoreo").addClass("active");
		imprime_registros();	
	});
	
	$("#nav").on('click', '#Trips', function(e){
		$(".button2.active").removeClass("active");  
		$("#Trips").addClass("active");
		imprime_registros();	
	});
	
	// refresco pantalla
	setInterval(refrescarPantalla, 5000);
	
	$(window).resize(function(){
		$("body").width(0.98 * window.innerWidth);
		$(".divdatos").height(window.innerHeight - 270);
	});
	
}); 

 function refrescarPantalla(){	
	if( $("#BotRegistros").hasClass("active") ){
		refresca_Registros();
	}
	else if( $("#BotEventos").hasClass("active") ){
		refresca_Anuncios();
	}
	else if( $("#BotMonitoreo").hasClass("active") ){
		if( $("#Captores").hasClass("active") ){
			refresca_Captores();			
		}
		else if( $("#Corrientes").hasClass("active") ){
			refresca_Corrientes();			
		}
		else if( $("#Entradas").hasClass("active") ){
			refresca_Entradas();			
		}
		else if( $("#Modulos").hasClass("active") ){
			refresca_Modulos();
		}
	}
 }
 

function actualizarHora(time){
	$("#hora").text("Ultimo refresco: "+ time);
}
